<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Fields extends Model 
{

    protected $table = 'lim_fields';
    public $timestamps = true;
    protected $fillable = array('table_id', 'table_type', 'type', 'rank', 'system_name', 'icon');
    protected $visible = array('table_id', 'table_type', 'type', 'rank', 'system_name', 'icon');

    public function language()
    {
        return $this->hasOne('App\Models\FieldLanguage', 'lim_field_id')->where('lim_language_id', \Config::get('app.language_id'));
    }

    public function items()
    {
        return $this->hasMany('App\Models\FieldItems', 'lim_field_id');
    }

    public function table()
    {
        return $this->morphTo();
    }

    public function value()
    {
        return $this->hasOne('App\Models\FieldValues', 'lim_field_id');
    }

    public function languages()
    {
        return $this->hasMany('App\Models\FieldLanguage', 'lim_field_id');
    }

}